// Toggle Visibility.js
// 
// This is macro script. Place it into ~/Library/Application Support/Cheetah3D/scripts/Macro folder.
// 
// 2010-10-18 first
// 2010-11-25 made this work recursively.
// 
// To toggle 'visilbe in render' of selected object.

function main(doc) {

	if (typeof version == "function"  && parseFloat(version()) >= 7) {

		var objs = doc.selectedObjects( true );

		for (var i = 0;i < objs.length;i++) {

			var obj = objs[i];

			if ( obj || obj.childCount ) {
				toggleVisibility( obj );
			}
		}
	} else {

		var obj = doc.selectedObject();
		
		if ( obj || obj.childCount ) {
			toggleVisibility( obj );
		}

	}
}

function toggleVisibility( obj ) {
	var cc = obj.childCount();
	
	if (1) { // 1 => recursive / 0 => no recursive
		for (var i = 0;i < cc;i++) {
			var c = obj.childAtIndex( i );
			
			toggleVisibility( c );
		}
	}
	
	var tcount = obj.tagCount();
	for (var i = 0;i < tcount;++i) {
		var tag = obj.tagAtIndex(i);
		info = tag.parameterInfo();
		if (tag.type() == 103) {
			// 
			tag.setParameter("editorActive", (tag.getParameter("editorActive"))? false : true );
		}
	}
}